/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.playerprops;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mcjty.lib.varia.LevelTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;

public class FavoriteDestinationsProperties {
    private Set<GlobalPos> favoriteDestinations = new HashSet<GlobalPos>();

    public void copyFrom(FavoriteDestinationsProperties source) {
        this.favoriteDestinations = new HashSet<GlobalPos>(source.favoriteDestinations);
    }

    public boolean isDestinationFavorite(GlobalPos coordinate) {
        return this.favoriteDestinations.contains(coordinate);
    }

    public void setDestinationFavorite(GlobalPos coordinate, boolean favorite) {
        if (favorite) {
            this.favoriteDestinations.add(coordinate);
        } else {
            this.favoriteDestinations.remove(coordinate);
        }
    }

    public void saveNBTData(CompoundTag compound) {
        FavoriteDestinationsProperties.writeFavoritesToNBT(compound, this.favoriteDestinations);
    }

    private static void writeFavoritesToNBT(CompoundTag tagCompound, Collection<GlobalPos> destinations) {
        ListTag lst = new ListTag();
        for (GlobalPos destination : destinations) {
            CompoundTag tc = new CompoundTag();
            BlockPos c = destination.m_122646_();
            tc.m_128405_("x", c.m_123341_());
            tc.m_128405_("y", c.m_123342_());
            tc.m_128405_("z", c.m_123343_());
            tc.m_128359_("dim", destination.m_122640_().m_135782_().toString());
            lst.add((Object)tc);
        }
        tagCompound.m_128365_("destinations", (Tag)lst);
    }

    public void loadNBTData(CompoundTag compound) {
        this.favoriteDestinations.clear();
        FavoriteDestinationsProperties.readCoordinatesFromNBT(compound, this.favoriteDestinations);
    }

    private static void readCoordinatesFromNBT(CompoundTag tagCompound, Set<GlobalPos> destinations) {
        ListTag lst = tagCompound.m_128437_("destinations", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundTag tc = lst.m_128728_(i);
            BlockPos c = new BlockPos(tc.m_128451_("x"), tc.m_128451_("y"), tc.m_128451_("z"));
            destinations.add(GlobalPos.m_122643_((ResourceKey)LevelTools.getId((String)tc.m_128461_("dim")), (BlockPos)c));
        }
    }
}

